<?php
error_reporting(E_ALL & ~E_NOTICE);
set_time_limit(0);
session_start();

require("dirLIST_files/config.php");
require("dirLIST_files/functions.php");
require("dirLIST_files/persian_helper.php");
require("dirLIST_files/multilang.php");

$url_folder = isset($_GET['folder']) ? base64_decode(trim($_GET['folder'])) : '';
if(!empty($url_folder))
    $dir_to_browse .= $url_folder."/";

// Load time
if($load_time == 1)
    $start_time = array_sum(explode(" ",microtime()));

// Set view mode
if(isset($_SESSION['view_mode_session']))
    $view_mode = $_SESSION['view_mode_session'];

// Multi-language support
$lang_id = getCurrentLanguage();
$text = getMultiLangText($lang_id);
$is_logged_in = isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;

// Security check
if(count(explode("../",$url_folder)) > 1 || in_array(basename($url_folder), $exclude)) {
    die('دسترسی غیرمجاز');
}

if(strlen($url_folder) == 2 && $url_folder == "..") {
    die('دسترسی غیرمجاز');
}

// Check if directory exists
$folder_exists = true;
if($listing_mode == 0)
    $folder_exists = is_dir($dir_to_browse);

if($folder_exists == false) {
    die('پوشه مورد نظر یافت نشد');
}

// Get directory content
$dir_content = get_dir_content($dir_to_browse);
$folders = $dir_content['folders'] ?? array('name' => array(), 'date' => array(), 'link' => array());
$files = $dir_content['files'] ?? array('name' => array(), 'size' => array(), 'date' => array(), 'link' => array());
$images_detected = $dir_content['images_detected'] ?? 0;
$media_detected = $dir_content['media_detected'] ?? 0;

// Calculate folder sizes
if($view_mode == 1 && $show_folder_size_http == 1 && $listing_mode == 0) {
    $folders['size'] = array();
    foreach($folders['name'] as $key => $val) {
        $folders['size'][$key] = folder_size($dir_to_browse.$val);
    }
}

// Sort
$sort_by = isset($_SESSION['sort']['by']) ? $_SESSION['sort']['by'] : 0;
$sort_order = isset($_SESSION['sort']['order']) ? $_SESSION['sort']['order'] : 0;

if(!empty($folders['name'])) {
    if($sort_by == 0) {
        natcasesort($folders['name']);
        $folders_sorted = $folders['name'];
    } elseif($sort_by == 1 && isset($folders['size'])) {
        asort($folders['size'], SORT_NUMERIC);
        $folders_sorted = $folders['size'];
    } else {
        $folders_sorted = sort_by_date($folders['date']);
    }
    if($sort_order == 1)
        $folders_sorted = array_reverse($folders_sorted, TRUE);
} else {
    $folders_sorted = array();
}

if(!empty($files['name'])) {
    if($sort_by == 0) {
        natcasesort($files['name']);
        $files_sorted = $files['name'];
    } elseif($sort_by == 1) {
        asort($files['size'], SORT_NUMERIC);
        $files_sorted = $files['size'];
    } else {
        $files_sorted = sort_by_date($files['date'], $sort_order);
    }
    if($sort_order == 1)
        $files_sorted = array_reverse($files_sorted, TRUE);
} else {
    $files_sorted = array();
}

// Icons
if($view_mode == 0 || ($view_mode == 1 && $file_icons)) {
    $files_icons_array = icons($files['name'], $view_mode);
}

$this_file_name = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فهرست فایل‌ها - <?php echo htmlspecialchars(empty($url_folder) ? 'خانه' : $url_folder); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --secondary: #8b5cf6;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --info: #3b82f6;
            --bg: #ffffff;
            --bg-secondary: #f8fafc;
            --bg-tertiary: #f1f5f9;
            --text: #1e293b;
            --text-secondary: #64748b;
            --text-muted: #94a3b8;
            --border: #e2e8f0;
            --shadow: rgba(0, 0, 0, 0.1);
            --shadow-lg: rgba(0, 0, 0, 0.15);
            --radius: 12px;
            --radius-sm: 8px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        [data-theme="dark"] {
            --bg: #0f172a;
            --bg-secondary: #1e293b;
            --bg-tertiary: #334155;
            --text: #f1f5f9;
            --text-secondary: #cbd5e1;
            --text-muted: #94a3b8;
            --border: #334155;
            --shadow: rgba(0, 0, 0, 0.3);
            --shadow-lg: rgba(0, 0, 0, 0.5);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            background: var(--bg-secondary);
            color: var(--text);
            line-height: 1.6;
            direction: rtl;
            transition: var(--transition);
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        /* Header */
        .header {
            background: var(--bg);
            border-radius: var(--radius);
            padding: 24px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px var(--shadow);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 16px;
        }

        .header-title {
            font-size: 24px;
            font-weight: 700;
            color: var(--text);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .header-title svg {
            width: 32px;
            height: 32px;
            color: var(--primary);
        }

        .header-actions {
            display: flex;
            gap: 12px;
            align-items: center;
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: var(--radius-sm);
            font-family: 'Vazirmatn', sans-serif;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px var(--shadow);
        }

        .btn-icon {
            padding: 10px;
            background: var(--bg-tertiary);
            color: var(--text);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .btn-icon:hover {
            background: var(--border);
            transform: scale(1.1);
        }

        /* Language Selector with Flags */
        .language-selector {
            position: relative;
        }

        .current-flag {
            font-size: 24px;
            cursor: pointer;
            padding: 8px;
            border-radius: 50%;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
        }

        .current-flag:hover {
            background: var(--bg-tertiary);
            transform: scale(1.1);
        }

        .language-menu {
            position: absolute;
            top: 100%;
            left: 0;
            margin-top: 8px;
            background: var(--bg);
            border-radius: var(--radius-sm);
            box-shadow: 0 8px 24px var(--shadow-lg);
            min-width: 180px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: var(--transition);
            z-index: 1000;
            border: 1px solid var(--border);
        }

        .language-menu.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .lang-option {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            text-decoration: none;
            color: var(--text);
            transition: var(--transition);
            border-bottom: 1px solid var(--border);
        }

        .lang-option:last-child {
            border-bottom: none;
        }

        .lang-option:hover {
            background: var(--bg-secondary);
        }

        .lang-option.active {
            background: var(--primary);
            color: white;
        }

        .lang-option .flag {
            font-size: 20px;
        }

        .file-actions {
            display: flex;
            gap: 8px;
            opacity: 0;
            transition: var(--transition);
        }

        .file-item:hover .file-actions,
        .file-card:hover .file-actions {
            opacity: 1;
        }

        .action-btn {
            padding: 6px 12px;
            border: none;
            border-radius: 6px;
            font-size: 12px;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }

        .action-btn-edit {
            background: var(--info);
            color: white;
        }

        .action-btn-delete {
            background: var(--danger);
            color: white;
        }

        .action-btn-rename {
            background: var(--warning);
            color: white;
        }

        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px var(--shadow);
        }

        /* Search */
        .search-box {
            position: relative;
            flex: 1;
            max-width: 400px;
        }

        .search-input {
            width: 100%;
            padding: 12px 16px 12px 48px;
            border: 2px solid var(--border);
            border-radius: var(--radius-sm);
            background: var(--bg);
            color: var(--text);
            font-family: 'Vazirmatn', sans-serif;
            font-size: 14px;
            transition: var(--transition);
        }

        .search-input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
        }

        .search-icon {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-muted);
            width: 20px;
            height: 20px;
        }

        /* Breadcrumb */
        .breadcrumb {
            background: var(--bg);
            border-radius: var(--radius);
            padding: 16px 24px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px var(--shadow);
            display: flex;
            align-items: center;
            gap: 8px;
            flex-wrap: wrap;
        }

        .breadcrumb-item {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--text-secondary);
            text-decoration: none;
            transition: var(--transition);
        }

        .breadcrumb-item:hover {
            color: var(--primary);
        }

        .breadcrumb-separator {
            color: var(--text-muted);
        }

        /* Stats */
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 16px;
            margin-bottom: 24px;
        }

        .stat-card {
            background: var(--bg);
            border-radius: var(--radius);
            padding: 20px;
            box-shadow: 0 2px 8px var(--shadow);
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 24px var(--shadow-lg);
        }

        .stat-label {
            font-size: 14px;
            color: var(--text-secondary);
            margin-bottom: 8px;
        }

        .stat-value {
            font-size: 28px;
            font-weight: 700;
            color: var(--text);
        }

        /* Toolbar */
        .toolbar {
            background: var(--bg);
            border-radius: var(--radius);
            padding: 16px 24px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px var(--shadow);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 16px;
        }

        .toolbar-left, .toolbar-right {
            display: flex;
            gap: 12px;
            align-items: center;
        }

        /* File List */
        .file-list {
            background: var(--bg);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: 0 2px 8px var(--shadow);
        }

        .file-header {
            background: var(--bg-tertiary);
            padding: 16px 24px;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr;
            gap: 16px;
            border-bottom: 2px solid var(--border);
            font-weight: 600;
            color: var(--text-secondary);
        }

        .file-item {
            padding: 16px 24px;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr;
            gap: 16px;
            align-items: center;
            border-bottom: 1px solid var(--border);
            transition: var(--transition);
            cursor: pointer;
        }

        .file-item:hover {
            background: var(--bg-secondary);
        }

        .file-item.folder {
            background: linear-gradient(90deg, rgba(99, 102, 241, 0.05) 0%, transparent 100%);
        }

        .file-item.folder:hover {
            background: linear-gradient(90deg, rgba(99, 102, 241, 0.1) 0%, transparent 100%);
        }

        .file-name {
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 500;
        }

        .file-icon {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
        }

        .file-link {
            color: var(--text);
            text-decoration: none;
            transition: var(--transition);
        }

        .file-link:hover {
            color: var(--primary);
        }

        .file-size, .file-date {
            color: var(--text-secondary);
            font-size: 14px;
        }

        /* Grid View */
        .file-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            gap: 20px;
            padding: 24px;
        }

        .file-card {
            background: var(--bg);
            border-radius: var(--radius);
            padding: 20px;
            text-align: center;
            box-shadow: 0 2px 8px var(--shadow);
            transition: var(--transition);
            cursor: pointer;
            text-decoration: none;
            color: var(--text);
            display: block;
        }

        .file-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 32px var(--shadow-lg);
        }

        .file-card-icon {
            width: 64px;
            height: 64px;
            margin: 0 auto 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
        }

        .file-card-name {
            font-weight: 500;
            margin-bottom: 8px;
            word-break: break-word;
        }

        .file-card-meta {
            font-size: 12px;
            color: var(--text-secondary);
        }

        /* Upload Area */
        .upload-area {
            background: var(--bg);
            border-radius: var(--radius);
            padding: 40px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px var(--shadow);
            text-align: center;
            border: 2px dashed var(--border);
            transition: var(--transition);
        }

        .upload-area.dragover {
            border-color: var(--primary);
            background: rgba(99, 102, 241, 0.05);
        }

        .upload-input {
            display: none;
        }

        .upload-label {
            cursor: pointer;
            display: inline-block;
            padding: 12px 24px;
            background: var(--primary);
            color: white;
            border-radius: var(--radius-sm);
            font-weight: 500;
            transition: var(--transition);
        }

        .upload-label:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 80px 20px;
            color: var(--text-secondary);
        }

        .empty-state-icon {
            width: 120px;
            height: 120px;
            margin: 0 auto 24px;
            opacity: 0.3;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                align-items: stretch;
            }

            .file-header, .file-item {
                grid-template-columns: 1fr;
                gap: 8px;
            }

            .file-grid {
                grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
                gap: 12px;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .file-item, .file-card {
            animation: fadeIn 0.3s ease-out;
        }

        /* Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: var(--bg-secondary);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--text-muted);
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"/>
                </svg>
                <span>مدیریت فایل‌ها</span>
            </div>
            <div class="header-actions">
                <div class="search-box">
                    <input type="text" class="search-input" id="searchInput" placeholder="<?php echo $text['search']; ?>...">
                    <svg class="search-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="11" cy="11" r="8"/>
                        <path d="m21 21-4.35-4.35"/>
                    </svg>
                </div>
                
                <!-- Language Selector with Flags -->
                <div class="language-selector">
                    <div class="current-flag" onclick="toggleLanguageMenu()">
                        <?php
                        $flags = ['🇮🇷', '🇬🇧', '🇩🇪', '🇫🇷', '🇪🇸', '🇸🇦'];
                        echo $flags[$lang_id];
                        ?>
                    </div>
                    <div class="language-menu" id="languageMenu">
                        <a href="javascript:void(0)" onclick="changeLanguage(0)" class="lang-option <?php echo $lang_id == 0 ? 'active' : ''; ?>">
                            <span class="flag">🇮🇷</span>
                            <span><?php echo $text['persian']; ?></span>
                        </a>
                        <a href="javascript:void(0)" onclick="changeLanguage(1)" class="lang-option <?php echo $lang_id == 1 ? 'active' : ''; ?>">
                            <span class="flag">🇬🇧</span>
                            <span><?php echo $text['english']; ?></span>
                        </a>
                        <a href="javascript:void(0)" onclick="changeLanguage(2)" class="lang-option <?php echo $lang_id == 2 ? 'active' : ''; ?>">
                            <span class="flag">🇩🇪</span>
                            <span><?php echo $text['german']; ?></span>
                        </a>
                        <a href="javascript:void(0)" onclick="changeLanguage(3)" class="lang-option <?php echo $lang_id == 3 ? 'active' : ''; ?>">
                            <span class="flag">🇫🇷</span>
                            <span><?php echo $text['french']; ?></span>
                        </a>
                        <a href="javascript:void(0)" onclick="changeLanguage(4)" class="lang-option <?php echo $lang_id == 4 ? 'active' : ''; ?>">
                            <span class="flag">🇪🇸</span>
                            <span><?php echo $text['spanish']; ?></span>
                        </a>
                        <a href="javascript:void(0)" onclick="changeLanguage(5)" class="lang-option <?php echo $lang_id == 5 ? 'active' : ''; ?>">
                            <span class="flag">🇸🇦</span>
                            <span><?php echo $text['arabic']; ?></span>
                        </a>
                    </div>
                </div>
                
                <button class="btn-icon" id="themeToggle" title="<?php echo $text['dark_mode']; ?>">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="5"/>
                        <path d="M12 1v2M12 21v2M4.22 4.22l1.42 1.42M18.36 18.36l1.42 1.42M1 12h2M21 12h2M4.22 19.78l1.42-1.42M18.36 5.64l1.42-1.42"/>
                    </svg>
                </button>
                <a href="dirLIST_files/change_view.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn-icon" title="<?php echo $view_mode == 0 ? $text['view_list'] : $text['view_grid']; ?>">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="3" y="3" width="7" height="7"/><rect x="14" y="3" width="7" height="7"/>
                        <rect x="14" y="14" width="7" height="7"/><rect x="3" y="14" width="7" height="7"/>
                    </svg>
                </a>
                
                <!-- Admin Login/Logout -->
                <?php if($is_logged_in): ?>
                    <a href="dirLIST_files/admin_login.php?logout=true&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn btn-primary" style="font-size: 12px; padding: 8px 16px;">
                        <?php echo $text['admin_logout']; ?>
                    </a>
                <?php elseif($admin_login_link == 1): ?>
                    <a href="dirLIST_files/admin_login.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn btn-primary" style="font-size: 12px; padding: 8px 16px;">
                        <?php echo $text['admin_login']; ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Breadcrumb -->
        <div class="breadcrumb">
            <a href="<?php echo $this_file_name; ?>" class="breadcrumb-item">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M3 9l9-7 9 7v11a2 2 0 01-2 2H5a2 2 0 01-2-2z"/>
                    <polyline points="9 22 9 12 15 12 15 22"/>
                </svg>
                <?php echo $text['home']; ?>
            </a>
            <?php if(!empty($url_folder)): ?>
                <?php
                $folders_in_url = explode("/", $url_folder);
                foreach($folders_in_url as $i => $folder):
                    $temp = "";
                    for($j=0; $j<=$i; $j++) {
                        $temp .= ($j > 0 ? "/" : "") . $folders_in_url[$j];
                    }
                ?>
                    <span class="breadcrumb-separator">/</span>
                    <a href="<?php echo $this_file_name; ?>?folder=<?php echo base64_encode($temp); ?>" class="breadcrumb-item">
                        <?php echo htmlspecialchars($folder); ?>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <!-- Stats -->
        <div class="stats">
            <div class="stat-card">
                <div class="stat-label"><?php echo $text['total_folders']; ?></div>
                <div class="stat-value"><?php echo toPersianNumber(count($folders['name'])); ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label"><?php echo $text['total_files']; ?></div>
                <div class="stat-value"><?php echo toPersianNumber(count($files['name'])); ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label"><?php echo $text['total_size']; ?></div>
                <div class="stat-value"><?php echo formatFileSize(array_sum($files['size'] ?? array()) + array_sum($folders['size'] ?? array())); ?></div>
            </div>
        </div>

        <!-- Toolbar -->
        <div class="toolbar">
            <div class="toolbar-left">
                <a href="dirLIST_files/sort.php?by=name&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn btn-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 6h18M7 12h10M11 18h2"/>
                    </svg>
                    <?php echo $text['name']; ?>
                </a>
                <a href="dirLIST_files/sort.php?by=size&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn" style="background: var(--bg-tertiary);">
                    <?php echo $text['size']; ?>
                </a>
                <a href="dirLIST_files/sort.php?by=date&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn" style="background: var(--bg-tertiary);">
                    <?php echo $text['date']; ?>
                </a>
            </div>
            <div class="toolbar-right">
                <?php if($images_detected && $enable_gallery): ?>
                    <a href="dirLIST_files/gallery.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn" style="background: var(--bg-tertiary);">
                        <?php echo $text['gallery']; ?>
                    </a>
                <?php endif; ?>
                <?php if($media_detected && $enable_media_player): ?>
                    <a href="dirLIST_files/media_player.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="btn" style="background: var(--bg-tertiary);">
                        <?php echo $text['media_player']; ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- File List/Grid -->
        <?php if(empty($folders['name']) && empty($files['name'])): ?>
            <div class="empty-state">
                <svg class="empty-state-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/>
                    <polyline points="7 10 12 15 17 10"/>
                    <line x1="12" y1="15" x2="12" y2="3"/>
                </svg>
                <h3><?php echo $text['empty_folder']; ?></h3>
            </div>
        <?php else: ?>
            <?php if($view_mode == 1): ?>
                <!-- List View -->
                <div class="file-list">
                    <div class="file-header">
                        <div><?php echo $text['name']; ?></div>
                        <div><?php echo $text['size']; ?></div>
                        <div><?php echo $text['date']; ?></div>
                    </div>
                    <?php foreach($folders_sorted as $key => $val): ?>
                        <div class="file-item folder" data-name="<?php echo htmlspecialchars($folders['name'][$key]); ?>">
                            <div class="file-name" style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
                                <div style="display: flex; align-items: center; gap: 12px; flex: 1;">
                                    <div class="file-icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M22 19a2 2 0 01-2 2H4a2 2 0 01-2-2V5a2 2 0 012-2h5l2 3h9a2 2 0 012 2z"/>
                                        </svg>
                                    </div>
                                    <a href="<?php echo $this_file_name; ?>?folder=<?php echo base64_encode($folders['link'][$key]); ?>" class="file-link">
                                        <?php echo htmlspecialchars($folders['name'][$key]); ?>
                                    </a>
                                </div>
                                <?php if($is_logged_in): ?>
                                    <div class="file-actions">
                                        <button onclick="renameItem('<?php echo htmlspecialchars($folders['name'][$key]); ?>', 'folder')" class="action-btn action-btn-rename" title="<?php echo $text['rename']; ?>">
                                            <?php echo $text['rename']; ?>
                                        </button>
                                        <button onclick="deleteItem('<?php echo htmlspecialchars($folders['name'][$key]); ?>', 'folder')" class="action-btn action-btn-delete" title="<?php echo $text['delete']; ?>">
                                            <?php echo $text['delete']; ?>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="file-size"><?php echo isset($folders['size'][$key]) ? formatFileSize($folders['size'][$key]) : '-'; ?></div>
                            <div class="file-date"><?php 
                                $dateStr = $folders['date'][$key];
                                $timestamp = strtotime($dateStr);
                                echo $timestamp !== false ? toPersianDate($timestamp) : toPersianNumber($dateStr);
                            ?></div>
                        </div>
                    <?php endforeach; ?>
                    <?php foreach($files_sorted as $key => $val): ?>
                        <div class="file-item" data-name="<?php echo htmlspecialchars($files['name'][$key]); ?>">
                            <div class="file-name" style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
                                <div style="display: flex; align-items: center; gap: 12px; flex: 1;">
                                    <div class="file-icon">
                                        <img src="dirLIST_files/icons/<?php echo $files_icons_array[$key] ?? 'unknown.gif'; ?>" width="24" height="24" alt="">
                                    </div>
                                    <a href="<?php echo htmlspecialchars($files['link'][$key]); ?>" class="file-link" target="_blank">
                                        <?php echo htmlspecialchars($files['name'][$key]); ?>
                                    </a>
                                </div>
                                <?php if($is_logged_in): ?>
                                    <div class="file-actions">
                                        <?php 
                                        $file_ext = strtolower(strrchr($files['name'][$key], '.'));
                                        $is_text = in_array($file_ext, ['.txt', '.php', '.js', '.css', '.html', '.json', '.xml', '.md']);
                                        $is_image = in_array($file_ext, ['.jpg', '.jpeg', '.png', '.gif', '.webp']);
                                        $is_video = in_array($file_ext, ['.mp4', '.avi', '.mov', '.wmv', '.flv']);
                                        $is_audio = in_array($file_ext, ['.mp3', '.wav', '.ogg', '.m4a']);
                                        ?>
                                        <?php if($is_text): ?>
                                            <button onclick="editFile('<?php echo htmlspecialchars($files['name'][$key]); ?>')" class="action-btn action-btn-edit" title="<?php echo $text['edit']; ?>">
                                                <?php echo $text['edit']; ?>
                                            </button>
                                        <?php endif; ?>
                                        <button onclick="previewFile('<?php echo htmlspecialchars($files['name'][$key]); ?>', '<?php echo $is_image ? 'image' : ($is_video ? 'video' : ($is_audio ? 'audio' : 'file')); ?>')" class="action-btn action-btn-edit" title="<?php echo $text['preview']; ?>">
                                            <?php echo $text['preview']; ?>
                                        </button>
                                        <button onclick="renameItem('<?php echo htmlspecialchars($files['name'][$key]); ?>', 'file')" class="action-btn action-btn-rename" title="<?php echo $text['rename']; ?>">
                                            <?php echo $text['rename']; ?>
                                        </button>
                                        <button onclick="deleteItem('<?php echo htmlspecialchars($files['name'][$key]); ?>', 'file')" class="action-btn action-btn-delete" title="<?php echo $text['delete']; ?>">
                                            <?php echo $text['delete']; ?>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="file-size"><?php echo formatFileSize($files['size'][$key]); ?></div>
                            <div class="file-date"><?php 
                                $dateStr = $files['date'][$key];
                                $timestamp = strtotime($dateStr);
                                echo $timestamp !== false ? toPersianDate($timestamp) : toPersianNumber($dateStr);
                            ?></div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <!-- Grid View -->
                <div class="file-grid">
                    <?php foreach($folders_sorted as $key => $val): ?>
                        <a href="<?php echo $this_file_name; ?>?folder=<?php echo base64_encode($folders['link'][$key]); ?>" class="file-card folder" data-name="<?php echo htmlspecialchars($folders['name'][$key]); ?>">
                            <div class="file-card-icon">
                                <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M22 19a2 2 0 01-2 2H4a2 2 0 01-2-2V5a2 2 0 012-2h5l2 3h9a2 2 0 012 2z"/>
                                </svg>
                            </div>
                            <div class="file-card-name"><?php echo htmlspecialchars($folders['name'][$key]); ?></div>
                            <div class="file-card-meta"><?php 
                                $dateStr = $folders['date'][$key];
                                $timestamp = strtotime($dateStr);
                                echo $timestamp !== false ? toPersianDate($timestamp) : toPersianNumber($dateStr);
                            ?></div>
                        </a>
                    <?php endforeach; ?>
                    <?php foreach($files_sorted as $key => $val): ?>
                        <a href="<?php echo htmlspecialchars($files['link'][$key]); ?>" class="file-card" data-name="<?php echo htmlspecialchars($files['name'][$key]); ?>" target="_blank">
                            <div class="file-card-icon">
                                <img src="dirLIST_files/icons_large/<?php echo $files_icons_array[$key] ?? 'unknown.png'; ?>" width="48" height="48" alt="">
                            </div>
                            <div class="file-card-name"><?php echo htmlspecialchars($files['name'][$key]); ?></div>
                            <div class="file-card-meta">
                                <?php 
                                echo formatFileSize($files['size'][$key]); 
                                echo ' • ';
                                $dateStr = $files['date'][$key];
                                $timestamp = strtotime($dateStr);
                                echo $timestamp !== false ? toPersianDate($timestamp) : toPersianNumber($dateStr);
                                ?>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <!-- Upload Area (Only for Admin) -->
        <?php if($file_uploads == 1 && $listing_mode == 0 && $is_logged_in): ?>
            <div class="upload-area" id="uploadArea">
                <form action="dirLIST_files/process_upload.php" method="post" enctype="multipart/form-data" id="uploadForm">
                    <input type="file" name="file" id="fileInput" class="upload-input" multiple>
                    <input type="hidden" name="folder" value="<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>">
                    <label for="fileInput" class="upload-label">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="display: inline-block; vertical-align: middle; margin-left: 8px;">
                            <path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/>
                            <polyline points="17 8 12 3 7 8"/>
                            <line x1="12" y1="3" x2="12" y2="15"/>
                        </svg>
                        <?php echo $text['upload_file']; ?>
                    </label>
                    <p style="margin-top: 16px; color: var(--text-secondary); font-size: 14px;">
                        <?php echo $text['max_size']; ?>: <?php echo toPersianNumber(max_upload_size()); ?> بایت
                    </p>
                </form>
            </div>
        <?php elseif($file_uploads == 1 && $listing_mode == 0 && !$is_logged_in): ?>
            <div class="upload-area" style="opacity: 0.5; pointer-events: none;">
                <p style="color: var(--text-secondary);"><?php echo $text['only_admin_upload']; ?></p>
            </div>
        <?php endif; ?>

        <!-- Admin Panel (Management Tools) -->
        <?php if($is_logged_in): ?>
            <div class="admin-panel" style="background: var(--bg); border-radius: var(--radius); padding: 20px; margin-top: 24px; box-shadow: 0 2px 8px var(--shadow);">
                <h3 style="margin-bottom: 16px; color: var(--text);"><?php echo $text['admin_panel']; ?></h3>
                <div style="display: flex; gap: 12px; flex-wrap: wrap;">
                    <button onclick="createNewFolder()" class="btn btn-primary">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 5v14M5 12h14"/>
                        </svg>
                        <?php echo $text['new_folder']; ?>
                    </button>
                    <button onclick="createNewFile()" class="btn btn-primary">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M14 2H6a2 2 0 00-2 2v16a2 2 0 002 2h12a2 2 0 002-2V8z"/>
                            <polyline points="14 2 14 8 20 8"/>
                        </svg>
                        <?php echo $text['new_file']; ?>
                    </button>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <script>
        // Language Menu Toggle
        function toggleLanguageMenu() {
            const menu = document.getElementById('languageMenu');
            menu.classList.toggle('show');
        }

        // Close language menu when clicking outside
        document.addEventListener('click', function(event) {
            const selector = document.querySelector('.language-selector');
            const menu = document.getElementById('languageMenu');
            if (selector && !selector.contains(event.target)) {
                menu.classList.remove('show');
            }
        });

        // Language Change
        function changeLanguage(langId) {
            window.location = 'dirLIST_files/set_language.php?lang_id=' + langId + '&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>';
        }

        // Admin Functions
        function createNewFolder() {
            const name = prompt('<?php echo $text['new_folder']; ?>:');
            if(name) {
                window.location = 'dirLIST_files/edit_files/create_folder.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&name=' + encodeURIComponent(name);
            }
        }

        function createNewFile() {
            const name = prompt('<?php echo $text['new_file']; ?>:');
            if(name) {
                window.location = 'dirLIST_files/edit_files/create_file.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&name=' + encodeURIComponent(name);
            }
        }

        // File Management Functions
        function base64Encode(str) {
            return btoa(unescape(encodeURIComponent(str)));
        }

        function deleteItem(itemName, itemType) {
            if(confirm('<?php echo $text['sure_delete']; ?> ' + itemName + '?\n<?php echo $text['cannot_undo']; ?>')) {
                window.location = 'dirLIST_files/edit_files/delete.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&item_name=' + base64Encode(itemName) + '&type=' + itemType;
            }
        }

        function renameItem(itemName, itemType) {
            const newName = prompt('<?php echo $text['rename']; ?>:', itemName);
            if(newName && newName !== itemName) {
                window.location = 'dirLIST_files/edit_files/rename.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&item_name=' + base64Encode(itemName) + '&new_name=' + encodeURIComponent(newName) + '&type=' + itemType;
            }
        }

        function editFile(fileName) {
            window.open('dirLIST_files/edit_files/edit.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&file=' + base64Encode(fileName), '_blank', 'width=800,height=600');
        }

        function previewFile(fileName, fileType) {
            const url = '<?php echo $dir_to_browse; ?>' + fileName;
            if(fileType === 'image') {
                window.open(url, '_blank');
            } else if(fileType === 'video') {
                window.open('dirLIST_files/video_player.php?file=' + base64Encode(fileName) + '&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>', '_blank', 'width=900,height=600');
            } else if(fileType === 'audio') {
                window.open('dirLIST_files/audio_player.php?file=' + base64Encode(fileName) + '&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>', '_blank', 'width=500,height=300');
            } else {
                window.open(url, '_blank');
            }
        }
    </script>

    <script>
        // Theme Toggle
        const themeToggle = document.getElementById('themeToggle');
        const html = document.documentElement;
        
        const currentTheme = localStorage.getItem('theme') || 'light';
        html.setAttribute('data-theme', currentTheme);
        
        themeToggle.addEventListener('click', () => {
            const current = html.getAttribute('data-theme');
            const newTheme = current === 'dark' ? 'light' : 'dark';
            html.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
        });

        // Search
        const searchInput = document.getElementById('searchInput');
        const fileItems = document.querySelectorAll('.file-item, .file-card');
        
        searchInput.addEventListener('input', (e) => {
            const query = e.target.value.toLowerCase();
            fileItems.forEach(item => {
                const name = item.getAttribute('data-name')?.toLowerCase() || '';
                if(name.includes(query)) {
                    item.style.display = '';
                } else {
                    item.style.display = 'none';
                }
            });
        });

        // Drag & Drop Upload
        const uploadArea = document.getElementById('uploadArea');
        const fileInput = document.getElementById('fileInput');
        
        if(uploadArea && fileInput) {
            ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
                uploadArea.addEventListener(eventName, preventDefaults, false);
            });

            function preventDefaults(e) {
                e.preventDefault();
                e.stopPropagation();
            }

            ['dragenter', 'dragover'].forEach(eventName => {
                uploadArea.addEventListener(eventName, () => {
                    uploadArea.classList.add('dragover');
                });
            });

            ['dragleave', 'drop'].forEach(eventName => {
                uploadArea.addEventListener(eventName, () => {
                    uploadArea.classList.remove('dragover');
                });
            });

            uploadArea.addEventListener('drop', (e) => {
                const dt = e.dataTransfer;
                const files = dt.files;
                fileInput.files = files;
                document.getElementById('uploadForm').submit();
            });

            uploadArea.addEventListener('click', () => {
                fileInput.click();
            });
        }

        // Load time
        <?php if($load_time == 1): ?>
        const loadTime = <?php echo sprintf("%.3f", array_sum(explode(" ",microtime())) - $start_time); ?>;
        console.log('زمان بارگذاری: ' + loadTime + ' ثانیه');
        <?php endif; ?>
    </script>
</body>
</html>
