<?php
require('config.php');
require('multilang.php');

$lang_id = getCurrentLanguage();
$text = getMultiLangText($lang_id);

$folder = isset($_GET['folder']) ? base64_decode($_GET['folder']) : '';
$file = isset($_GET['file']) ? base64_decode($_GET['file']) : '';

if(empty($file)) {
    die('File not specified');
}

$file_path = '../' . $dir_to_browse . ($folder ? $folder . '/' : '') . $file;
?>
<!DOCTYPE html>
<html lang="<?php echo $lang_id == 5 ? 'ar' : ($lang_id == 0 ? 'fa' : 'en'); ?>" dir="<?php echo $lang_id == 5 || $lang_id == 0 ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $text['video_player']; ?> - <?php echo htmlspecialchars($file); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: #000;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }

        video {
            max-width: 100%;
            max-height: 100vh;
            width: auto;
            height: auto;
        }
    </style>
</head>
<body>
    <video controls autoplay>
        <source src="<?php echo htmlspecialchars($file_path); ?>" type="video/mp4">
        Your browser does not support the video tag.
    </video>
</body>
</html>

