<?php
// Helper functions for Persian localization

// Convert English numbers to Persian
function toPersianNumber($string) {
    $persian = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
    $english = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    return str_replace($english, $persian, $string);
}

// Convert Persian date
function toPersianDate($dateString) {
    // If it's a timestamp, convert it
    if(is_numeric($dateString)) {
        $timestamp = $dateString;
    } else {
        $timestamp = strtotime($dateString);
    }
    
    if($timestamp === false) {
        return toPersianNumber($dateString);
    }
    
    $months = array(
        'January' => 'ژانویه', 'February' => 'فوریه', 'March' => 'مارس',
        'April' => 'آوریل', 'May' => 'می', 'June' => 'ژوئن',
        'July' => 'ژوئیه', 'August' => 'اوت', 'September' => 'سپتامبر',
        'October' => 'اکتبر', 'November' => 'نوامبر', 'December' => 'دسامبر'
    );
    
    $date = date("d F Y", $timestamp);
    foreach($months as $en => $fa) {
        $date = str_replace($en, $fa, $date);
    }
    return toPersianNumber($date);
}

// Format file size in Persian
function formatFileSize($bytes) {
    $units = array('بایت', 'کیلوبایت', 'مگابایت', 'گیگابایت', 'ترابایت');
    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
    $bytes /= pow(1024, $pow);
    return toPersianNumber(sprintf('%.2f', $bytes)) . ' ' . $units[$pow];
}

// Persian text translations
function getPersianText() {
    return array(
        'index_of' => 'فهرست',
        'home' => 'خانه',
        'folder' => 'پوشه',
        'file' => 'فایل',
        'name' => 'نام',
        'size' => 'حجم',
        'date' => 'تاریخ',
        'upload' => 'آپلود',
        'search' => 'جستجو',
        'view_list' => 'نمایش لیستی',
        'view_grid' => 'نمایش شبکه‌ای',
        'dark_mode' => 'حالت تاریک',
        'light_mode' => 'حالت روشن',
        'empty_folder' => 'این پوشه خالی است',
        'total_folders' => 'تعداد پوشه‌ها',
        'total_files' => 'تعداد فایل‌ها',
        'total_size' => 'حجم کل',
        'no_results' => 'نتیجه‌ای یافت نشد',
        'upload_file' => 'آپلود فایل',
        'drag_drop' => 'فایل را اینجا بکشید یا کلیک کنید',
        'max_size' => 'حداکثر حجم',
        'gallery' => 'گالری تصاویر',
        'media_player' => 'پخش‌کننده رسانه',
        'download' => 'دانلود',
        'preview' => 'پیش‌نمایش',
        'delete' => 'حذف',
        'rename' => 'تغییر نام',
        'loading' => 'در حال بارگذاری...',
        'error' => 'خطا',
        'success' => 'موفق',
        'cancel' => 'لغو',
        'confirm' => 'تأیید',
        'sure_delete' => 'آیا مطمئن هستید؟',
        'cannot_undo' => 'این عمل قابل بازگشت نیست'
    );
}
?>

