<?php
// Multi-language support system
// Languages: 0=Persian, 1=English, 2=German, 3=French, 4=Spanish, 5=Arabic

function getMultiLangText($lang_id = 0) {
    $texts = array(
        // Persian (0)
        'index_of' => array('فهرست', 'Index of', 'Index der', 'Index de', 'Índice de', 'فهرس'),
        'home' => array('خانه', 'Home', 'Startseite', 'Accueil', 'Inicio', 'الرئيسية'),
        'folder' => array('پوشه', 'Folder', 'Ordner', 'Dossier', 'Carpeta', 'مجلد'),
        'file' => array('فایل', 'File', 'Datei', 'Fichier', 'Archivo', 'ملف'),
        'name' => array('نام', 'Name', 'Name', 'Nom', 'Nombre', 'الاسم'),
        'size' => array('حجم', 'Size', 'Größe', 'Taille', 'Tamaño', 'الحجم'),
        'date' => array('تاریخ', 'Date', 'Datum', 'Date', 'Fecha', 'التاريخ'),
        'upload' => array('آپلود', 'Upload', 'Hochladen', 'Télécharger', 'Subir', 'رفع'),
        'search' => array('جستجو', 'Search', 'Suchen', 'Rechercher', 'Buscar', 'بحث'),
        'view_list' => array('نمایش لیستی', 'List View', 'Listenansicht', 'Vue liste', 'Vista de lista', 'عرض القائمة'),
        'view_grid' => array('نمایش شبکه‌ای', 'Grid View', 'Rasteransicht', 'Vue grille', 'Vista de cuadrícula', 'عرض الشبكة'),
        'dark_mode' => array('حالت تاریک', 'Dark Mode', 'Dunkler Modus', 'Mode sombre', 'Modo oscuro', 'الوضع الداكن'),
        'light_mode' => array('حالت روشن', 'Light Mode', 'Heller Modus', 'Mode clair', 'Modo claro', 'الوضع الفاتح'),
        'empty_folder' => array('این پوشه خالی است', 'This folder is empty', 'Dieser Ordner ist leer', 'Ce dossier est vide', 'Esta carpeta está vacía', 'هذا المجلد فارغ'),
        'total_folders' => array('تعداد پوشه‌ها', 'Total Folders', 'Gesamt Ordner', 'Total dossiers', 'Total carpetas', 'إجمالي المجلدات'),
        'total_files' => array('تعداد فایل‌ها', 'Total Files', 'Gesamt Dateien', 'Total fichiers', 'Total archivos', 'إجمالي الملفات'),
        'total_size' => array('حجم کل', 'Total Size', 'Gesamtgröße', 'Taille totale', 'Tamaño total', 'الحجم الإجمالي'),
        'no_results' => array('نتیجه‌ای یافت نشد', 'No results found', 'Keine Ergebnisse', 'Aucun résultat', 'No se encontraron resultados', 'لم يتم العثور على نتائج'),
        'upload_file' => array('آپلود فایل', 'Upload File', 'Datei hochladen', 'Télécharger fichier', 'Subir archivo', 'رفع ملف'),
        'drag_drop' => array('فایل را اینجا بکشید', 'Drag file here', 'Datei hierher ziehen', 'Glisser fichier ici', 'Arrastrar archivo aquí', 'اسحب الملف هنا'),
        'max_size' => array('حداکثر حجم', 'Max Size', 'Maximale Größe', 'Taille max', 'Tamaño máximo', 'الحجم الأقصى'),
        'gallery' => array('گالری تصاویر', 'Image Gallery', 'Bildergalerie', 'Galerie d\'images', 'Galería de imágenes', 'معرض الصور'),
        'media_player' => array('پخش‌کننده رسانه', 'Media Player', 'Media Player', 'Lecteur multimédia', 'Reproductor multimedia', 'مشغل الوسائط'),
        'download' => array('دانلود', 'Download', 'Herunterladen', 'Télécharger', 'Descargar', 'تحميل'),
        'preview' => array('پیش‌نمایش', 'Preview', 'Vorschau', 'Aperçu', 'Vista previa', 'معاينة'),
        'delete' => array('حذف', 'Delete', 'Löschen', 'Supprimer', 'Eliminar', 'حذف'),
        'rename' => array('تغییر نام', 'Rename', 'Umbenennen', 'Renommer', 'Renombrar', 'إعادة تسمية'),
        'edit' => array('ویرایش', 'Edit', 'Bearbeiten', 'Modifier', 'Editar', 'تعديل'),
        'create' => array('ایجاد', 'Create', 'Erstellen', 'Créer', 'Crear', 'إنشاء'),
        'new_folder' => array('پوشه جدید', 'New Folder', 'Neuer Ordner', 'Nouveau dossier', 'Nueva carpeta', 'مجلد جديد'),
        'new_file' => array('فایل جدید', 'New File', 'Neue Datei', 'Nouveau fichier', 'Nuevo archivo', 'ملف جديد'),
        'copy' => array('کپی', 'Copy', 'Kopieren', 'Copier', 'Copiar', 'نسخ'),
        'move' => array('جابجایی', 'Move', 'Verschieben', 'Déplacer', 'Mover', 'نقل'),
        'select_all' => array('انتخاب همه', 'Select All', 'Alle auswählen', 'Tout sélectionner', 'Seleccionar todo', 'تحديد الكل'),
        'deselect_all' => array('لغو انتخاب', 'Deselect All', 'Auswahl aufheben', 'Tout désélectionner', 'Deseleccionar todo', 'إلغاء التحديد'),
        'admin_login' => array('ورود مدیر', 'Admin Login', 'Admin-Anmeldung', 'Connexion admin', 'Inicio de sesión de administrador', 'تسجيل دخول المدير'),
        'admin_logout' => array('خروج مدیر', 'Admin Logout', 'Admin-Abmeldung', 'Déconnexion admin', 'Cerrar sesión de administrador', 'تسجيل خروج المدير'),
        'username' => array('نام کاربری', 'Username', 'Benutzername', 'Nom d\'utilisateur', 'Nombre de usuario', 'اسم المستخدم'),
        'password' => array('رمز عبور', 'Password', 'Passwort', 'Mot de passe', 'Contraseña', 'كلمة المرور'),
        'login' => array('ورود', 'Login', 'Anmelden', 'Se connecter', 'Iniciar sesión', 'تسجيل الدخول'),
        'logout' => array('خروج', 'Logout', 'Abmelden', 'Se déconnecter', 'Cerrar sesión', 'تسجيل الخروج'),
        'admin_panel' => array('پنل مدیریت', 'Admin Panel', 'Admin-Panel', 'Panneau d\'administration', 'Panel de administración', 'لوحة التحكم'),
        'file_manager' => array('مدیریت فایل', 'File Manager', 'Dateimanager', 'Gestionnaire de fichiers', 'Administrador de archivos', 'مدير الملفات'),
        'sure_delete' => array('آیا مطمئن هستید؟', 'Are you sure?', 'Sind Sie sicher?', 'Êtes-vous sûr?', '¿Estás seguro?', 'هل أنت متأكد؟'),
        'cannot_undo' => array('این عمل قابل بازگشت نیست', 'This action cannot be undone', 'Diese Aktion kann nicht rückgängig gemacht werden', 'Cette action ne peut pas être annulée', 'Esta acción no se puede deshacer', 'لا يمكن التراجع عن هذا الإجراء'),
        'success' => array('موفق', 'Success', 'Erfolg', 'Succès', 'Éxito', 'نجاح'),
        'error' => array('خطا', 'Error', 'Fehler', 'Erreur', 'Error', 'خطأ'),
        'cancel' => array('لغو', 'Cancel', 'Abbrechen', 'Annuler', 'Cancelar', 'إلغاء'),
        'confirm' => array('تأیید', 'Confirm', 'Bestätigen', 'Confirmer', 'Confirmar', 'تأكيد'),
        'save' => array('ذخیره', 'Save', 'Speichern', 'Enregistrer', 'Guardar', 'حفظ'),
        'close' => array('بستن', 'Close', 'Schließen', 'Fermer', 'Cerrar', 'إغلاق'),
        'loading' => array('در حال بارگذاری...', 'Loading...', 'Laden...', 'Chargement...', 'Cargando...', 'جاري التحميل...'),
        'no_access' => array('دسترسی ندارید', 'Access Denied', 'Zugriff verweigert', 'Accès refusé', 'Acceso denegado', 'تم رفض الوصول'),
        'only_admin_upload' => array('فقط مدیر می‌تواند آپلود کند', 'Only admin can upload', 'Nur Admin kann hochladen', 'Seul l\'admin peut télécharger', 'Solo el administrador puede subir', 'يمكن للمدير فقط الرفع'),
        'file_editor' => array('ویرایشگر فایل', 'File Editor', 'Dateieditor', 'Éditeur de fichier', 'Editor de archivos', 'محرر الملفات'),
        'save_changes' => array('ذخیره تغییرات', 'Save Changes', 'Änderungen speichern', 'Enregistrer les modifications', 'Guardar cambios', 'حفظ التغييرات'),
        'file_content' => array('محتوای فایل', 'File Content', 'Dateiinhalt', 'Contenu du fichier', 'Contenido del archivo', 'محتوى الملف'),
        'video_player' => array('پخش‌کننده ویدیو', 'Video Player', 'Video-Player', 'Lecteur vidéo', 'Reproductor de video', 'مشغل الفيديو'),
        'audio_player' => array('پخش‌کننده صوتی', 'Audio Player', 'Audio-Player', 'Lecteur audio', 'Reproductor de audio', 'مشغل الصوت'),
        'image_viewer' => array('نمایشگر تصویر', 'Image Viewer', 'Bildbetrachter', 'Visionneuse d\'images', 'Visor de imágenes', 'عارض الصور'),
        'text_editor' => array('ویرایشگر متن', 'Text Editor', 'Texteditor', 'Éditeur de texte', 'Editor de texto', 'محرر النص'),
        'select_language' => array('انتخاب زبان', 'Select Language', 'Sprache auswählen', 'Sélectionner la langue', 'Seleccionar idioma', 'اختر اللغة'),
        'persian' => array('فارسی', 'Persian', 'Persisch', 'Persan', 'Persa', 'الفارسية'),
        'english' => array('انگلیسی', 'English', 'Englisch', 'Anglais', 'Inglés', 'الإنجليزية'),
        'german' => array('آلمانی', 'German', 'Deutsch', 'Allemand', 'Alemán', 'الألمانية'),
        'french' => array('فرانسه', 'French', 'Französisch', 'Français', 'Francés', 'الفرنسية'),
        'spanish' => array('اسپانیایی', 'Spanish', 'Spanisch', 'Espagnol', 'Español', 'الإسبانية'),
        'arabic' => array('عربی', 'Arabic', 'Arabisch', 'Arabe', 'Árabe', 'العربية'),
    );

    $result = array();
    foreach($texts as $key => $values) {
        $result[$key] = isset($values[$lang_id]) ? $values[$lang_id] : $values[0];
    }
    return $result;
}

// Get current language from session or default
function getCurrentLanguage() {
    if(isset($_SESSION['lang_id'])) {
        return $_SESSION['lang_id'];
    }
    return 0; // Default: Persian
}

// Set language
function setLanguage($lang_id) {
    $_SESSION['lang_id'] = $lang_id;
}

// Get text for current language
function t($key) {
    global $text;
    return isset($text[$key]) ? $text[$key] : $key;
}
?>

