<?php
session_start();
if(!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    die('Access Denied');
}

require('../config.php');
require('../functions.php');
require('../multilang.php');

$lang_id = getCurrentLanguage();
$text = getMultiLangText($lang_id);

$folder = isset($_GET['folder']) ? base64_decode($_GET['folder']) : '';
$file = isset($_GET['file']) ? base64_decode($_GET['file']) : '';

if(empty($file)) {
    die('File not specified');
}

$file_path = '../../' . $dir_to_browse . ($folder ? $folder . '/' : '') . $file;

if(isset($_POST['content'])) {
    file_put_contents($file_path, $_POST['content']);
    echo '<script>alert("' . $text['success'] . '"); window.close(); window.opener.location.reload();</script>';
    exit;
}

$content = file_exists($file_path) ? file_get_contents($file_path) : '';
?>
<!DOCTYPE html>
<html lang="<?php echo $lang_id == 5 ? 'ar' : ($lang_id == 0 ? 'fa' : 'en'); ?>" dir="<?php echo $lang_id == 5 || $lang_id == 0 ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $text['file_editor']; ?> - <?php echo htmlspecialchars($file); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 20px;
        }

        .editor-header {
            background: #252526;
            padding: 15px 20px;
            border-radius: 8px 8px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0;
        }

        .editor-title {
            font-size: 16px;
            font-weight: 600;
        }

        .editor-actions {
            display: flex;
            gap: 10px;
        }

        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 14px;
            transition: all 0.3s;
        }

        .btn-save {
            background: #0e639c;
            color: white;
        }

        .btn-save:hover {
            background: #1177bb;
        }

        .btn-close {
            background: #5a5a5a;
            color: white;
        }

        .btn-close:hover {
            background: #6a6a6a;
        }

        .editor-content {
            background: #1e1e1e;
        }

        textarea {
            width: 100%;
            height: calc(100vh - 120px);
            background: #1e1e1e;
            color: #d4d4d4;
            border: none;
            padding: 20px;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            line-height: 1.6;
            resize: none;
            outline: none;
        }

        textarea:focus {
            outline: none;
        }
    </style>
</head>
<body>
    <form method="post">
        <div class="editor-header">
            <div class="editor-title"><?php echo $text['file_editor']; ?>: <?php echo htmlspecialchars($file); ?></div>
            <div class="editor-actions">
                <button type="submit" class="btn btn-save"><?php echo $text['save']; ?></button>
                <button type="button" onclick="window.close()" class="btn btn-close"><?php echo $text['close']; ?></button>
            </div>
        </div>
        <div class="editor-content">
            <textarea id="editor" name="content"><?php echo htmlspecialchars($content); ?></textarea>
        </div>
    </form>

    <script>
        // Auto-resize
        const textarea = document.getElementById('editor');
        textarea.style.height = 'calc(100vh - 120px)';
    </script>
</body>
</html>

