<?php
require('config.php');
require('multilang.php');

$lang_id = getCurrentLanguage();
$text = getMultiLangText($lang_id);

$folder = isset($_GET['folder']) ? base64_decode($_GET['folder']) : '';
$file = isset($_GET['file']) ? base64_decode($_GET['file']) : '';

if(empty($file)) {
    die('File not specified');
}

$file_path = '../' . $dir_to_browse . ($folder ? $folder . '/' : '') . $file;
?>
<!DOCTYPE html>
<html lang="<?php echo $lang_id == 5 ? 'ar' : ($lang_id == 0 ? 'fa' : 'en'); ?>" dir="<?php echo $lang_id == 5 || $lang_id == 0 ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $text['audio_player']; ?> - <?php echo htmlspecialchars($file); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            font-family: 'Vazirmatn', sans-serif;
        }

        .player-container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            text-align: center;
            max-width: 500px;
            width: 90%;
        }

        .player-title {
            font-size: 20px;
            margin-bottom: 20px;
            color: #333;
        }

        audio {
            width: 100%;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="player-container">
        <div class="player-title"><?php echo htmlspecialchars($file); ?></div>
        <audio controls autoplay>
            <source src="<?php echo htmlspecialchars($file_path); ?>" type="audio/mpeg">
            Your browser does not support the audio tag.
        </audio>
    </div>
</body>
</html>

