<?php
session_start();
if(!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header("Location: admin_login.php?folder=" . ($_GET['folder'] ?? ''));
    exit;
}

require('config.php');
require('functions.php');
require('multilang.php');

$lang_id = getCurrentLanguage();
$text = getMultiLangText($lang_id);

$url_folder = isset($_GET['folder']) ? base64_decode(trim($_GET['folder'])) : '';
if(!empty($url_folder))
    $dir_to_browse .= $url_folder."/";

// Get directory content
$dir_content = get_dir_content($dir_to_browse);
$folders = $dir_content['folders'] ?? array('name' => array(), 'date' => array(), 'link' => array());
$files = $dir_content['files'] ?? array('name' => array(), 'size' => array(), 'date' => array(), 'link' => array());

// Sort
$sort_by = isset($_SESSION['sort']['by']) ? $_SESSION['sort']['by'] : 0;
$sort_order = isset($_SESSION['sort']['order']) ? $_SESSION['sort']['order'] : 0;

if(!empty($folders['name'])) {
    if($sort_by == 0) {
        natcasesort($folders['name']);
        $folders_sorted = $folders['name'];
    } else {
        $folders_sorted = sort_by_date($folders['date']);
    }
    if($sort_order == 1)
        $folders_sorted = array_reverse($folders_sorted, TRUE);
} else {
    $folders_sorted = array();
}

if(!empty($files['name'])) {
    if($sort_by == 0) {
        natcasesort($files['name']);
        $files_sorted = $files['name'];
    } elseif($sort_by == 1) {
        asort($files['size'], SORT_NUMERIC);
        $files_sorted = $files['size'];
    } else {
        $files_sorted = sort_by_date($files['date'], $sort_order);
    }
    if($sort_order == 1)
        $files_sorted = array_reverse($files_sorted, TRUE);
} else {
    $files_sorted = array();
}

// Icons
$files_icons_array = icons($files['name'], 1);

$this_file_name = 'index.php';
$current_dir = $url_folder ? $url_folder : 'home';
?>
<!DOCTYPE html>
<html lang="<?php echo $lang_id == 5 ? 'ar' : ($lang_id == 0 ? 'fa' : 'en'); ?>" dir="<?php echo $lang_id == 5 || $lang_id == 0 ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $text['admin_panel']; ?> - <?php echo $text['file_manager']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --secondary: #8b5cf6;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --info: #3b82f6;
            --bg: #ffffff;
            --bg-secondary: #f8fafc;
            --bg-tertiary: #f1f5f9;
            --text: #1e293b;
            --text-secondary: #64748b;
            --text-muted: #94a3b8;
            --border: #e2e8f0;
            --shadow: rgba(0, 0, 0, 0.1);
            --shadow-lg: rgba(0, 0, 0, 0.15);
            --sidebar-width: 280px;
        }

        [data-theme="dark"] {
            --bg: #0f172a;
            --bg-secondary: #1e293b;
            --bg-tertiary: #334155;
            --text: #f1f5f9;
            --text-secondary: #cbd5e1;
            --text-muted: #94a3b8;
            --border: #334155;
            --shadow: rgba(0, 0, 0, 0.3);
            --shadow-lg: rgba(0, 0, 0, 0.5);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            background: var(--bg-secondary);
            color: var(--text);
            direction: rtl;
        }

        .admin-container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            width: var(--sidebar-width);
            background: var(--bg);
            border-left: 1px solid var(--border);
            box-shadow: 2px 0 8px var(--shadow);
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            z-index: 100;
        }

        .sidebar-header {
            padding: 24px;
            border-bottom: 1px solid var(--border);
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
        }

        .sidebar-header h2 {
            font-size: 20px;
            margin-bottom: 8px;
        }

        .sidebar-header p {
            font-size: 12px;
            opacity: 0.9;
        }

        .sidebar-menu {
            padding: 16px 0;
        }

        .menu-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px 24px;
            color: var(--text);
            text-decoration: none;
            transition: var(--transition);
            border-right: 3px solid transparent;
        }

        .menu-item:hover {
            background: var(--bg-secondary);
            border-right-color: var(--primary);
        }

        .menu-item.active {
            background: var(--bg-secondary);
            border-right-color: var(--primary);
            color: var(--primary);
            font-weight: 600;
        }

        .menu-item svg {
            width: 20px;
            height: 20px;
        }

        .menu-section {
            padding: 16px 24px 8px;
            font-size: 12px;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-right: var(--sidebar-width);
            padding: 24px;
        }

        .content-header {
            background: var(--bg);
            border-radius: 12px;
            padding: 24px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px var(--shadow);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .content-title {
            font-size: 24px;
            font-weight: 700;
        }

        .header-actions {
            display: flex;
            gap: 12px;
            align-items: center;
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px var(--shadow);
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-icon {
            padding: 10px;
            background: var(--bg-tertiary);
            color: var(--text);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Language Selector */
        .language-selector {
            position: relative;
        }

        .current-flag {
            font-size: 24px;
            cursor: pointer;
            padding: 8px;
            border-radius: 50%;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
        }

        .current-flag:hover {
            background: var(--bg-tertiary);
            transform: scale(1.1);
        }

        .language-menu {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 8px;
            background: var(--bg);
            border-radius: 8px;
            box-shadow: 0 8px 24px var(--shadow-lg);
            min-width: 180px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: var(--transition);
            z-index: 1000;
            border: 1px solid var(--border);
        }

        .language-menu.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .lang-option {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            text-decoration: none;
            color: var(--text);
            transition: var(--transition);
            border-bottom: 1px solid var(--border);
        }

        .lang-option:last-child {
            border-bottom: none;
        }

        .lang-option:hover {
            background: var(--bg-secondary);
        }

        .lang-option.active {
            background: var(--primary);
            color: white;
        }

        .lang-option .flag {
            font-size: 20px;
        }

        /* File List */
        .file-list {
            background: var(--bg);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 8px var(--shadow);
        }

        .file-header {
            background: var(--bg-tertiary);
            padding: 16px 24px;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 150px;
            gap: 16px;
            border-bottom: 2px solid var(--border);
            font-weight: 600;
            color: var(--text-secondary);
        }

        .file-item {
            padding: 16px 24px;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 150px;
            gap: 16px;
            align-items: center;
            border-bottom: 1px solid var(--border);
            transition: var(--transition);
        }

        .file-item:hover {
            background: var(--bg-secondary);
        }

        .file-item.folder {
            background: linear-gradient(90deg, rgba(99, 102, 241, 0.05) 0%, transparent 100%);
        }

        .file-name {
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 500;
        }

        .file-icon {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
        }

        .file-link {
            color: var(--text);
            text-decoration: none;
            transition: var(--transition);
        }

        .file-link:hover {
            color: var(--primary);
        }

        .file-actions {
            display: flex;
            gap: 6px;
        }

        .action-btn {
            padding: 6px 12px;
            border: none;
            border-radius: 6px;
            font-size: 12px;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 4px;
            font-family: 'Vazirmatn', sans-serif;
        }

        .action-btn-edit {
            background: var(--info);
            color: white;
        }

        .action-btn-delete {
            background: var(--danger);
            color: white;
        }

        .action-btn-rename {
            background: var(--warning);
            color: white;
        }

        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px var(--shadow);
        }

        /* Breadcrumb */
        .breadcrumb {
            background: var(--bg);
            border-radius: 12px;
            padding: 16px 24px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px var(--shadow);
            display: flex;
            align-items: center;
            gap: 8px;
            flex-wrap: wrap;
        }

        .breadcrumb-item {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--text-secondary);
            text-decoration: none;
            transition: var(--transition);
        }

        .breadcrumb-item:hover {
            color: var(--primary);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(100%);
                transition: transform 0.3s;
            }

            .sidebar.open {
                transform: translateX(0);
            }

            .main-content {
                margin-right: 0;
            }

            .file-header, .file-item {
                grid-template-columns: 1fr;
                gap: 8px;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h2><?php echo $text['admin_panel']; ?></h2>
                <p><?php echo $text['file_manager']; ?></p>
            </div>

            <div class="sidebar-menu">
                <div class="menu-section"><?php echo $text['file_manager']; ?></div>
                <a href="admin_panel.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="menu-item active">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"/>
                    </svg>
                    <?php echo $text['file_manager']; ?>
                </a>
                <a href="../index.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="menu-item">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 01-2 2H5a2 2 0 01-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <?php echo $text['home']; ?>
                </a>

                <div class="menu-section"><?php echo $text['create']; ?></div>
                <a href="javascript:void(0)" onclick="createNewFolder()" class="menu-item">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 5v14M5 12h14"/>
                    </svg>
                    <?php echo $text['new_folder']; ?>
                </a>
                <a href="javascript:void(0)" onclick="createNewFile()" class="menu-item">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M14 2H6a2 2 0 00-2 2v16a2 2 0 002 2h12a2 2 0 002-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                    </svg>
                    <?php echo $text['new_file']; ?>
                </a>

                <div class="menu-section"><?php echo $text['admin_panel']; ?></div>
                <a href="admin_login.php?logout=true&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>" class="menu-item">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 21H5a2 2 0 01-2-2V5a2 2 0 012-2h4"/>
                        <polyline points="16 17 21 12 16 7"/>
                        <line x1="21" y1="12" x2="9" y2="12"/>
                    </svg>
                    <?php echo $text['admin_logout']; ?>
                </a>
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <div class="content-header">
                <div class="content-title"><?php echo $text['file_manager']; ?></div>
                <div class="header-actions">
                    <!-- Language Selector -->
                    <div class="language-selector">
                        <div class="current-flag" onclick="toggleLanguageMenu()">
                            <?php
                            $flags = ['🇮🇷', '🇬🇧', '🇩🇪', '🇫🇷', '🇪🇸', '🇸🇦'];
                            echo $flags[$lang_id];
                            ?>
                        </div>
                        <div class="language-menu" id="languageMenu">
                            <a href="javascript:void(0)" onclick="changeLanguage(0)" class="lang-option <?php echo $lang_id == 0 ? 'active' : ''; ?>">
                                <span class="flag">🇮🇷</span>
                                <span><?php echo $text['persian']; ?></span>
                            </a>
                            <a href="javascript:void(0)" onclick="changeLanguage(1)" class="lang-option <?php echo $lang_id == 1 ? 'active' : ''; ?>">
                                <span class="flag">🇬🇧</span>
                                <span><?php echo $text['english']; ?></span>
                            </a>
                            <a href="javascript:void(0)" onclick="changeLanguage(2)" class="lang-option <?php echo $lang_id == 2 ? 'active' : ''; ?>">
                                <span class="flag">🇩🇪</span>
                                <span><?php echo $text['german']; ?></span>
                            </a>
                            <a href="javascript:void(0)" onclick="changeLanguage(3)" class="lang-option <?php echo $lang_id == 3 ? 'active' : ''; ?>">
                                <span class="flag">🇫🇷</span>
                                <span><?php echo $text['french']; ?></span>
                            </a>
                            <a href="javascript:void(0)" onclick="changeLanguage(4)" class="lang-option <?php echo $lang_id == 4 ? 'active' : ''; ?>">
                                <span class="flag">🇪🇸</span>
                                <span><?php echo $text['spanish']; ?></span>
                            </a>
                            <a href="javascript:void(0)" onclick="changeLanguage(5)" class="lang-option <?php echo $lang_id == 5 ? 'active' : ''; ?>">
                                <span class="flag">🇸🇦</span>
                                <span><?php echo $text['arabic']; ?></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Breadcrumb -->
            <div class="breadcrumb">
                <a href="admin_panel.php" class="breadcrumb-item">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 01-2 2H5a2 2 0 01-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <?php echo $text['home']; ?>
                </a>
                <?php if(!empty($url_folder)): ?>
                    <?php
                    $folders_in_url = explode("/", $url_folder);
                    foreach($folders_in_url as $i => $folder):
                        $temp = "";
                        for($j=0; $j<=$i; $j++) {
                            $temp .= ($j > 0 ? "/" : "") . $folders_in_url[$j];
                        }
                    ?>
                        <span>/</span>
                        <a href="admin_panel.php?folder=<?php echo base64_encode($temp); ?>" class="breadcrumb-item">
                            <?php echo htmlspecialchars($folder); ?>
                        </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <!-- File List -->
            <div class="file-list">
                <div class="file-header">
                    <div><?php echo $text['name']; ?></div>
                    <div><?php echo $text['size']; ?></div>
                    <div><?php echo $text['date']; ?></div>
                    <div><?php echo $text['edit']; ?></div>
                </div>
                <?php foreach($folders_sorted as $key => $val): ?>
                    <div class="file-item folder">
                        <div class="file-name">
                            <div class="file-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M22 19a2 2 0 01-2 2H4a2 2 0 01-2-2V5a2 2 0 012-2h5l2 3h9a2 2 0 012 2z"/>
                                </svg>
                            </div>
                            <a href="admin_panel.php?folder=<?php echo base64_encode($folders['link'][$key]); ?>" class="file-link">
                                <?php echo htmlspecialchars($folders['name'][$key]); ?>
                            </a>
                        </div>
                        <div>-</div>
                        <div><?php 
                            $dateStr = $folders['date'][$key];
                            $timestamp = strtotime($dateStr);
                            echo $timestamp !== false ? date('Y-m-d', $timestamp) : $dateStr;
                        ?></div>
                        <div class="file-actions">
                            <button onclick="renameItem('<?php echo htmlspecialchars($folders['name'][$key]); ?>', 'folder')" class="action-btn action-btn-rename">
                                <?php echo $text['rename']; ?>
                            </button>
                            <button onclick="deleteItem('<?php echo htmlspecialchars($folders['name'][$key]); ?>', 'folder')" class="action-btn action-btn-delete">
                                <?php echo $text['delete']; ?>
                            </button>
                        </div>
                    </div>
                <?php endforeach; ?>
                <?php foreach($files_sorted as $key => $val): ?>
                    <div class="file-item">
                        <div class="file-name">
                            <div class="file-icon">
                                <img src="icons/<?php echo $files_icons_array[$key] ?? 'unknown.gif'; ?>" width="24" height="24" alt="">
                            </div>
                            <a href="../<?php echo htmlspecialchars($files['link'][$key]); ?>" class="file-link" target="_blank">
                                <?php echo htmlspecialchars($files['name'][$key]); ?>
                            </a>
                        </div>
                        <div><?php 
                            require('persian_helper.php');
                            echo formatFileSize($files['size'][$key]); 
                        ?></div>
                        <div><?php 
                            $dateStr = $files['date'][$key];
                            $timestamp = strtotime($dateStr);
                            echo $timestamp !== false ? date('Y-m-d', $timestamp) : $dateStr;
                        ?></div>
                        <div class="file-actions">
                            <?php 
                            $file_ext = strtolower(strrchr($files['name'][$key], '.'));
                            $is_text = in_array($file_ext, ['.txt', '.php', '.js', '.css', '.html', '.json', '.xml', '.md']);
                            ?>
                            <?php if($is_text): ?>
                                <button onclick="editFile('<?php echo htmlspecialchars($files['name'][$key]); ?>')" class="action-btn action-btn-edit">
                                    <?php echo $text['edit']; ?>
                                </button>
                            <?php endif; ?>
                            <button onclick="renameItem('<?php echo htmlspecialchars($files['name'][$key]); ?>', 'file')" class="action-btn action-btn-rename">
                                <?php echo $text['rename']; ?>
                            </button>
                            <button onclick="deleteItem('<?php echo htmlspecialchars($files['name'][$key]); ?>', 'file')" class="action-btn action-btn-delete">
                                <?php echo $text['delete']; ?>
                            </button>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <script>
        // Language Menu Toggle
        function toggleLanguageMenu() {
            const menu = document.getElementById('languageMenu');
            menu.classList.toggle('show');
        }

        // Close language menu when clicking outside
        document.addEventListener('click', function(event) {
            const selector = document.querySelector('.language-selector');
            const menu = document.getElementById('languageMenu');
            if (selector && !selector.contains(event.target)) {
                menu.classList.remove('show');
            }
        });

        // Language Change
        function changeLanguage(langId) {
            window.location = 'set_language.php?lang_id=' + langId + '&folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>';
        }

        // Admin Functions
        function base64Encode(str) {
            return btoa(unescape(encodeURIComponent(str)));
        }

        function createNewFolder() {
            const name = prompt('<?php echo $text['new_folder']; ?>:');
            if(name) {
                window.location = 'edit_files/create_folder.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&name=' + encodeURIComponent(name);
            }
        }

        function createNewFile() {
            const name = prompt('<?php echo $text['new_file']; ?>:');
            if(name) {
                window.location = 'edit_files/create_file.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&name=' + encodeURIComponent(name);
            }
        }

        function deleteItem(itemName, itemType) {
            if(confirm('<?php echo $text['sure_delete']; ?> ' + itemName + '?\n<?php echo $text['cannot_undo']; ?>')) {
                window.location = 'edit_files/delete.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&item_name=' + base64Encode(itemName) + '&type=' + itemType;
            }
        }

        function renameItem(itemName, itemType) {
            const newName = prompt('<?php echo $text['rename']; ?>:', itemName);
            if(newName && newName !== itemName) {
                window.location = 'edit_files/rename.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&item_name=' + base64Encode(itemName) + '&new_name=' + encodeURIComponent(newName) + '&type=' + itemType;
            }
        }

        function editFile(fileName) {
            window.open('edit_files/edit.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>&file=' + base64Encode(fileName), '_blank', 'width=800,height=600');
        }
    </script>
</body>
</html>

