<?php
error_reporting(E_ALL & ~E_NOTICE);
require('config.php');
require('functions.php');
require('multilang.php');
session_start();

$lang_id = getCurrentLanguage();
$text = getMultiLangText($lang_id);
$dir = isset($_GET['dir']) ? $_GET['dir'] : 'rtl';

if(isset($_GET['logout']) && $_GET['logout'] == 'true') {
    $_SESSION['logged_in'] = false;
    unset($_SESSION['logged_in']);
    header("Location: ../index.php?folder=".($_GET['folder'] ?? ''));
    exit;
}

if(empty($admin_password)) {
    die('لطفاً رمز عبور را در فایل config.php تنظیم کنید');
}

$login_error = false;

if(isset($_POST['submit']) && $_POST['submit'] == 'Login') {
    if(isset($_POST['username']) && isset($_POST['password'])) {
        if($_POST['username'] == $admin_username && $_POST['password'] == $admin_password) {
            $_SESSION['logged_in'] = true;
            header("Location: ../index.php?folder=".($_POST['folder'] ?? ''));
            exit;
        } else {
            $login_error = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="<?php echo $lang_id == 5 ? 'ar' : ($lang_id == 0 ? 'fa' : 'en'); ?>" dir="<?php echo $dir; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $text['admin_login']; ?> - File Manager</title>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            direction: rtl;
        }

        .login-container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 400px;
            animation: slideIn 0.5s ease-out;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .login-header h1 {
            color: #667eea;
            font-size: 28px;
            margin-bottom: 10px;
        }

        .login-header p {
            color: #666;
            font-size: 14px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
            font-size: 14px;
        }

        .form-input {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 14px;
            transition: all 0.3s;
        }

        .form-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn-login {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }

        .error-message {
            background: #fee;
            color: #c33;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
            font-size: 14px;
            border: 1px solid #fcc;
        }

        .back-link {
            text-align: center;
            margin-top: 20px;
        }

        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
        }

        .back-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1><?php echo $text['admin_login']; ?></h1>
            <p><?php echo $text['file_manager']; ?></p>
        </div>

        <?php if($login_error): ?>
            <div class="error-message">
                <?php echo $text['error']; ?>: <?php echo $text['username']; ?> یا <?php echo $text['password']; ?> اشتباه است
            </div>
        <?php endif; ?>

        <form method="post" action="">
            <input type="hidden" name="folder" value="<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>">
            
            <div class="form-group">
                <label class="form-label"><?php echo $text['username']; ?></label>
                <input type="text" name="username" class="form-input" required autofocus>
            </div>

            <div class="form-group">
                <label class="form-label"><?php echo $text['password']; ?></label>
                <input type="password" name="password" class="form-input" required>
            </div>

            <button type="submit" name="submit" value="Login" class="btn-login">
                <?php echo $text['login']; ?>
            </button>
        </form>

        <div class="back-link">
            <a href="../index.php?folder=<?php echo htmlspecialchars($_GET['folder'] ?? ''); ?>">
                ← <?php echo $text['home']; ?>
            </a>
        </div>
    </div>
</body>
</html>
