# بررسی امنیتی و کیفیت کد - dirLIST v0.3.0

## ⚠️ مشکلات امنیتی بحرانی

### 1. رمز عبور در Plain Text
**فایل:** `dirLIST_files/config.php` - خط 21
```php
$admin_password = 'Rm@1658035-1';
```
**مشکل:** رمز عبور به صورت plain text ذخیره شده است.
**راه حل:** استفاده از `password_hash()` و `password_verify()`

### 2. آسیب‌پذیری XSS (Cross-Site Scripting)
**فایل:** `index.php` - خطوط متعدد
**مشکل:** استفاده مستقیم از `$_GET['folder']` در HTML/JavaScript بدون escape
**مثال:**
```php
echo $_GET['folder']; // خط 166, 171, 345, 347, 523, 528, 533, 569-571, 742, 806, 812
```
**راه حل:** استفاده از `htmlspecialchars()` یا `htmlentities()`

### 3. Authentication ضعیف
**فایل:** `dirLIST_files/admin_login.php` - خط 27
```php
if($_POST['username'] == $admin_username && $_POST['password'] == $admin_password)
```
**مشکلات:**
- مقایسه مستقیم پسورد بدون hash
- عدم وجود rate limiting
- عدم وجود CSRF protection
- عدم وجود session timeout

### 4. Path Traversal ناکافی
**فایل:** `index.php` - خط 307
```php
if(count(explode("../",$folder)) > 1 || in_array(basename($url_folder), $exclude))
```
**مشکل:** بررسی ناکافی برای path traversal
**راه حل:** استفاده از `realpath()` و مقایسه با `$dir_to_browse`

### 5. پنهان کردن خطاها
**فایل:** `index.php` - خط 40
```php
error_reporting(0);
```
**مشکل:** تمام خطاها پنهان می‌شوند
**راه حل:** استفاده از error logging در production

### 6. استفاده مستقیم از User Input
**فایل:** `index.php` - خط 47
```php
$url_folder = base64_decode(trim($_GET['folder']));
```
**مشکل:** عدم اعتبارسنجی کامل ورودی کاربر

## 🔧 مشکلات کیفیت کد

### 1. کد قدیمی PHP
- استفاده از PHP 4/5 style
- عدم استفاده از modern PHP features
- عدم استفاده از namespaces
- عدم استفاده از autoloading

### 2. عدم وجود Input Validation
- عدم استفاده از filter functions
- عدم sanitization مناسب

### 3. عدم وجود CSRF Protection
- تمام فرم‌ها بدون CSRF token

### 4. عدم وجود Rate Limiting
- امکان brute force attack

### 5. کد HTML/PHP مخلوط
- عدم جداسازی logic از presentation
- عدم استفاده از template engine

## 📋 توصیه‌های بهبود

### اولویت بالا (امنیتی)
1. ✅ Hash کردن رمز عبور
2. ✅ Escape کردن تمام خروجی‌ها
3. ✅ بهبود path traversal protection
4. ✅ اضافه کردن CSRF protection
5. ✅ اضافه کردن rate limiting

### اولویت متوسط
1. ✅ بهبود error handling
2. ✅ Input validation
3. ✅ Session security
4. ✅ استفاده از prepared statements (اگر دیتابیس اضافه شود)

### اولویت پایین
1. ✅ Refactoring کد
2. ✅ استفاده از modern PHP
3. ✅ جداسازی logic از presentation

## 🔒 اقدامات فوری

1. **تغییر رمز عبور فوری** - رمز عبور فعلی در کد قابل مشاهده است
2. **غیرفعال کردن file uploads** تا زمان رفع مشکلات امنیتی
3. **محدود کردن دسترسی** به فایل config.php
4. **بررسی لاگ‌ها** برای فعالیت مشکوک

## 📝 یادداشت

این یک اسکریپت قدیمی (v0.3.0) است و نیاز به به‌روزرسانی کامل دارد.
برای استفاده در production، باید تمام مشکلات امنیتی رفع شوند.

